/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.KmsPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.model.KmsPublicKeyDiscoveryInput;

public class KmsEcdhStaticConfigurations {
    private final KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery;
    private final KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey;

    protected KmsEcdhStaticConfigurations(BuilderImpl builder) {
        this.KmsPublicKeyDiscovery = builder.KmsPublicKeyDiscovery();
        this.KmsPrivateKeyToStaticPublicKey = builder.KmsPrivateKeyToStaticPublicKey();
    }

    public KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery() {
        return this.KmsPublicKeyDiscovery;
    }

    public KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey() {
        return this.KmsPrivateKeyToStaticPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery;
        protected KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsEcdhStaticConfigurations model) {
            this.KmsPublicKeyDiscovery = model.KmsPublicKeyDiscovery();
            this.KmsPrivateKeyToStaticPublicKey = model.KmsPrivateKeyToStaticPublicKey();
        }

        @Override
        public Builder KmsPublicKeyDiscovery(KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery) {
            this.KmsPublicKeyDiscovery = KmsPublicKeyDiscovery;
            return this;
        }

        @Override
        public KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery() {
            return this.KmsPublicKeyDiscovery;
        }

        @Override
        public Builder KmsPrivateKeyToStaticPublicKey(KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey) {
            this.KmsPrivateKeyToStaticPublicKey = KmsPrivateKeyToStaticPublicKey;
            return this;
        }

        @Override
        public KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey() {
            return this.KmsPrivateKeyToStaticPublicKey;
        }

        @Override
        public KmsEcdhStaticConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`KmsEcdhStaticConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new KmsEcdhStaticConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.KmsPublicKeyDiscovery, this.KmsPrivateKeyToStaticPublicKey};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder KmsPublicKeyDiscovery(KmsPublicKeyDiscoveryInput var1);

        public KmsPublicKeyDiscoveryInput KmsPublicKeyDiscovery();

        public Builder KmsPrivateKeyToStaticPublicKey(KmsPrivateKeyToStaticPublicKeyInput var1);

        public KmsPrivateKeyToStaticPublicKeyInput KmsPrivateKeyToStaticPublicKey();

        public KmsEcdhStaticConfigurations build();
    }
}

