"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactAce = _interopRequireDefault(require("react-ace"));
var _common = require("../common");
var _services = require("../../services");
var _i18n = require("../i18n");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var DEFAULT_MODE = 'text';
var DEFAULT_THEME = 'textmate';
function setOrRemoveAttribute(element, attributeName, value) {
  if (value === null || value === undefined) {
    element.removeAttribute(attributeName);
  } else {
    element.setAttribute(attributeName, value);
  }
}
var EuiCodeEditor = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiCodeEditor, _Component);
  var _super = _createSuper(EuiCodeEditor);
  function EuiCodeEditor() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiCodeEditor);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isHintActive: true,
      isEditing: false,
      name: (0, _services.htmlIdGenerator)()()
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "idGenerator", (0, _services.htmlIdGenerator)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "aceEditor", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "editorHint", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "aceEditorRef", function (aceEditor) {
      if (aceEditor) {
        _this.aceEditor = aceEditor;
        var textbox = aceEditor.editor.textInput.getElement();
        textbox.tabIndex = -1;
        textbox.addEventListener('keydown', _this.onKeydownAce);
        setOrRemoveAttribute(textbox, 'aria-label', _this.props['aria-label']);
        setOrRemoveAttribute(textbox, 'aria-labelledby', _this.props['aria-labelledby']);
        setOrRemoveAttribute(textbox, 'aria-describedby', _this.props['aria-describedby']);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onEscToExit", function () {
      _this.stopEditing();
      if (_this.editorHint) {
        _this.editorHint.focus();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeydownAce", function (event) {
      if (event.key === _services.keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        // Handles exiting edit mode when `isReadOnly` is set.
        // Other 'esc' cases handled by `stopEditingOnEsc` command.
        // Would run after `stopEditingOnEsc`.
        if (_this.aceEditor !== null && !_this.aceEditor.editor.completer && _this.state.isEditing) {
          _this.onEscToExit();
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocusAce", function (event, editor) {
      _this.setState({
        isEditing: true
      });
      if (_this.props.onFocus) {
        _this.props.onFocus(event, editor);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlurAce", function (event, editor) {
      _this.stopEditing();
      if (_this.props.onBlur) {
        _this.props.onBlur(event, editor);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "startEditing", function () {
      _this.setState({
        isHintActive: false
      });
      if (_this.aceEditor !== null) {
        _this.aceEditor.editor.textInput.focus();
      }
    });
    return _this;
  }
  (0, _createClass2.default)(EuiCodeEditor, [{
    key: "stopEditing",
    value: function stopEditing() {
      this.setState({
        isHintActive: true,
        isEditing: false
      });
    }
  }, {
    key: "isCustomMode",
    value: function isCustomMode() {
      return (0, _typeof2.default)(this.props.mode) === 'object';
    }
  }, {
    key: "setCustomMode",
    value: function setCustomMode() {
      if (this.aceEditor !== null) {
        this.aceEditor.editor.getSession().setMode(this.props.mode);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.isCustomMode()) {
        this.setCustomMode();
      }
      var _this$props = this.props,
        isReadOnly = _this$props.isReadOnly,
        id = _this$props.id;
      var textareaProps = {
        id: id,
        readOnly: isReadOnly
      };
      var el = document.getElementById(this.state.name);
      if (el) {
        var textarea = el.querySelector('textarea');
        if (textarea) (0, _common.keysOf)(textareaProps).forEach(function (key) {
          if (textareaProps[key]) textarea.setAttribute("".concat(key), textareaProps[key].toString());
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.mode !== prevProps.mode && this.isCustomMode()) {
        this.setCustomMode();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        width = _this$props2.width,
        height = _this$props2.height,
        onBlur = _this$props2.onBlur,
        isReadOnly = _this$props2.isReadOnly,
        setOptions = _this$props2.setOptions,
        cursorStart = _this$props2.cursorStart,
        _this$props2$mode = _this$props2.mode,
        mode = _this$props2$mode === void 0 ? DEFAULT_MODE : _this$props2$mode,
        _this$props2$dataTes = _this$props2['data-test-subj'],
        dataTestSubj = _this$props2$dataTes === void 0 ? 'codeEditorContainer' : _this$props2$dataTes,
        _this$props2$theme = _this$props2.theme,
        theme = _this$props2$theme === void 0 ? DEFAULT_THEME : _this$props2$theme,
        _this$props2$commands = _this$props2.commands,
        commands = _this$props2$commands === void 0 ? [] : _this$props2$commands,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, ["width", "height", "onBlur", "isReadOnly", "setOptions", "cursorStart", "mode", "data-test-subj", "theme", "commands"]);
      var classes = (0, _classnames.default)('euiCodeEditorWrapper', {
        'euiCodeEditorWrapper-isEditing': this.state.isEditing
      });
      var promptClasses = (0, _classnames.default)('euiCodeEditorKeyboardHint', {
        'euiCodeEditorKeyboardHint-isInactive': !this.state.isHintActive
      });
      var filteredCursorStart;
      var options = _objectSpread({}, setOptions);
      if (isReadOnly) {
        // Put the cursor at the beginning of the editor, so that it doesn't look like
        // a prompt to begin typing.
        filteredCursorStart = -1;
        Object.assign(options, {
          readOnly: true,
          highlightActiveLine: false,
          highlightGutterLine: false
        });
      } else {
        filteredCursorStart = cursorStart;
      }
      var prompt = /*#__PURE__*/_react.default.createElement("button", {
        className: promptClasses,
        id: this.idGenerator('codeEditor'),
        ref: function ref(hint) {
          _this2.editorHint = hint;
        },
        onClick: this.startEditing,
        "data-test-subj": "codeEditorHint"
      }, /*#__PURE__*/_react.default.createElement("p", {
        className: "euiText"
      }, isReadOnly ? /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiCodeEditor.startInteracting",
        default: "Press Enter to start interacting with the code."
      }) : /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiCodeEditor.startEditing",
        default: "Press Enter to start editing."
      })), /*#__PURE__*/_react.default.createElement("p", {
        className: "euiText"
      }, isReadOnly ? /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiCodeEditor.stopInteracting",
        default: "When you're done, press Escape to stop interacting with the code."
      }) : /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiCodeEditor.stopEditing",
        default: "When you're done, press Escape to stop editing."
      })));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: classes,
        style: {
          width: width,
          height: height
        },
        "data-test-subj": dataTestSubj
      }, prompt, /*#__PURE__*/_react.default.createElement(_reactAce.default
      // Setting a default, existing `mode` is necessary to properly initialize the editor
      // prior to dynamically setting a custom mode (https://github.com/elastic/oui/pull/2616)
      , (0, _extends2.default)({
        mode: this.isCustomMode() ? DEFAULT_MODE : mode // https://github.com/securingsincity/react-ace/pull/771
        ,
        name: this.state.name,
        theme: theme,
        ref: this.aceEditorRef,
        width: width,
        height: height,
        onFocus: this.onFocusAce,
        onBlur: this.onBlurAce,
        setOptions: options,
        editorProps: {
          $blockScrolling: Infinity
        },
        cursorStart: filteredCursorStart,
        commands: [
        // Handles exiting edit mode in all cases except `isReadOnly`
        // Runs before `onKeydownAce`.
        {
          name: 'stopEditingOnEsc',
          bindKey: {
            win: 'Esc',
            mac: 'Esc'
          },
          exec: this.onEscToExit
        }].concat((0, _toConsumableArray2.default)(commands))
      }, rest)));
    }
  }]);
  return EuiCodeEditor;
}(_react.Component);
exports.EuiCodeEditor = EuiCodeEditor;
(0, _defineProperty2.default)(EuiCodeEditor, "defaultProps", {
  setOptions: {}
});
EuiCodeEditor.propTypes = {
  width: _propTypes.default.string,
  height: _propTypes.default.string,
  onBlur: _propTypes.default.any,
  onFocus: _propTypes.default.any,
  isReadOnly: _propTypes.default.bool,
  setOptions: _propTypes.default.any.isRequired,
  cursorStart: _propTypes.default.number,
  "data-test-subj": _propTypes.default.string,
  /**
     * Select the `brace` theme
     * The matching theme file must also be imported from `brace` (e.g., `import 'brace/theme/github';`)
     */
  theme: _propTypes.default.any,
  /**
     * Use string for a built-in mode or object for a custom mode
     */
  mode: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  id: _propTypes.default.string
};